// Subscription Plan
export interface SubscriptionPlan {
  id: string;
  name: string;
  description: string;
  price: number;
  interval: 'monthly' | 'yearly';
  is_active: boolean;
  created_at: string;
  updated_at: string;
}

// Feature
export interface Feature {
  id: string;
  key: string;
  name: string;
  description: string;
  created_at: string;
  updated_at: string;
}

// Vendor Subscription
export interface VendorSubscription {
  id: string;
  vendor_id: string;
  plan_id: string;
  status: 'active' | 'cancelled' | 'expired' | 'trialing';
  trial_start: string | null;
  trial_end: string | null;
  current_period_start: string;
  current_period_end: string;
  created_at: string;
  updated_at: string;
}

// Plan-Feature Mapping
export interface PlanFeature {
  id: string;
  plan_id: string;
  feature_id: string;
  created_at: string;
}

// Trial Settings
export interface TrialSettings {
  id: string;
  duration_days: number;
  is_enabled: boolean;
  created_at: string;
  updated_at: string;
}

// API Response
export interface ApiResponse<T = any> {
  success: boolean;
  data?: T;
  message?: string;
  error?: string;
} 